/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class HscTransaction {
    public static final String ACTIVATE_SYS_PROFILE = "ActivateSystemProfileMethProv+";
    public static final String ACTIVATE_AND_POWER_ON = "ActivateAndPowerOnMethProv+";
    public static final String CIMOM_INFO = "CimomInfoMethProv+";
    public static final String DO_CSP_COMMAND = "doCSPCommand+";
    public static final String GET_DLPAR_SYS_INFO = "GetDLPARSysInfo+";
    public static final String HSC_INFO = "HscInfoMethProv+";
    public static final String LOG_SYSTEM_EVENT = "LogSystemEvent";
    public static final String MASTER_METH_PROV = "MasterMethProv+";
    public static final String OS_RESET = "OSResetMethProv+";
    public static final String PARTITION_ATIVATION = "PartitionActivateMethProv+";
    public static final String SEND_CSP_COMMAND = "SEND_CSP_CMD";
    public static final String TRACE_LOG = "TRACE_LOG";
    public static final int ENABLE_LOG = 0;
    public static final int DISABLE_LOG = 1;
    private static final int RUN = -1;
    public static final int NO_ERROR = 0;
    public static final int FAILED = 1;
    public static final int CANCEL = 2;
    public static final int PARENT_END = 3;
    public static final int HEARTBEAT = 20;
    public static final int RESUME = 21;
    public static final int SUSPEND = 22;
    private static final String INVALID_STRING = "INVALID";
    private static final String RUN_STRING = "RUN";
    private static final String NO_ERROR_STRING = "NO_ERROR";
    private static final String FAILED_STRING = "FAILED";
    private static final String CANCEL_STRING = "CANCEL";
    private static final String PARENT_END_STRING = "PARENT_END";
    private static final String HEARTBEAT_STRING = "HEARTBEAT";
    private static final String RESUME_STRING = "RESUME";
    private static final String SUSPEND_STRING = "SUSPEND";
    private static final String START_TRANSACTION = "START: ";
    private static final String SUSPEND_TRANSACTION = "SUSPEND: ";
    private static final String RESUME_TRANSACTION = "RESUME: ";
    private static final String HEARTBEAT_TRANSACTION = "HEARTBEAT: ";
    private static final String END_TRANSACTION = "END: ";
    private static final byte[] EOL = "\n".getBytes();
    private static int nextTransId = 0;
    private static FileOutputStream outStream = null;
    private String name;
    private int id = HscTransaction.getTransId();
    private int parentId;
    private long start;
    private long end;
    private int state;
    private long suspendTime;
    private String threadName;

    public HscTransaction(String string, String string2, int n) throws IOException {
        this.parentId = n;
        this.name = string;
        this.start = System.currentTimeMillis();
        this.end = 0L;
        this.suspendTime = 0L;
        this.state = -1;
        this.threadName = string2;
        this.dumpTransaction(START_TRANSACTION);
    }

    public static void setOutput(FileOutputStream fileOutputStream) {
        outStream = fileOutputStream;
    }

    public static void logChange(int n) throws IOException {
        if (null != outStream) {
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String string = "";
            switch (n) {
                case 0: {
                    string = "LOG START: " + date.toString() + " - " + new Long(l).toString();
                    break;
                }
                case 1: {
                    string = "LOG END: " + date.toString() + " - " + new Long(l).toString();
                }
            }
            try {
                outStream.write(string.getBytes());
                outStream.write(EOL);
            }
            catch (IOException iOException) {
                outStream = null;
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    private static synchronized int getTransId() {
        nextTransId = Integer.MAX_VALUE == nextTransId ? 1 : ++nextTransId;
        return nextTransId;
    }

    public int getId() {
        return this.id;
    }

    public void endTransaction(int n) throws IOException {
        this.end = System.currentTimeMillis();
        this.state = n;
        this.dumpTransaction(END_TRANSACTION);
    }

    public void heartBeat(String string) throws IOException {
        if (null != outStream) {
            try {
                outStream.write(HEARTBEAT_TRANSACTION.getBytes());
                if (null != string) {
                    outStream.write((string + " ").getBytes());
                }
                outStream.write(("thread:" + this.threadName + " name: " + this.name + " id:" + new Integer(this.id).toString() + " time = " + System.currentTimeMillis()).getBytes());
                outStream.write(EOL);
            }
            catch (IOException iOException) {
                outStream = null;
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    public void changeState(int n) throws IOException {
        String string;
        String string2;
        switch (n) {
            case 21: {
                if (22 == this.state) {
                    string2 = RESUME_TRANSACTION;
                    long l = System.currentTimeMillis();
                    long l2 = l - this.suspendTime;
                    string = "id:" + this.id + "suspend time = " + new Long(this.suspendTime).toString() + " resume time = " + new Long(l).toString() + " delta = " + new Long(l2).toString();
                    this.state = -1;
                    break;
                }
                return;
            }
            case 22: {
                if (-1 == this.state) {
                    this.suspendTime = System.currentTimeMillis();
                    string2 = SUSPEND_TRANSACTION;
                    string = "id:" + this.id + "suspend time = " + new Long(this.suspendTime).toString();
                    this.state = 22;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        if (null != outStream) {
            try {
                outStream.write(string2.getBytes());
                outStream.write(string.getBytes());
                outStream.write(EOL);
            }
            catch (IOException iOException) {
                outStream = null;
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    protected void dumpTransaction(String string) throws IOException {
        if (null != outStream) {
            try {
                outStream.write(string.getBytes());
                outStream.write(this.dumpString().getBytes());
                outStream.write(EOL);
            }
            catch (IOException iOException) {
                outStream = null;
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    public String toString() {
        return "HscTransaction[" + this.dumpString() + "]";
    }

    protected String dumpString() {
        return "thread:" + this.threadName + " name: " + this.name + " id:" + new Integer(this.id).toString() + " parentId:" + new Integer(this.parentId).toString() + " start:" + new Long(this.start).toString() + " end:" + new Long(this.end).toString() + " state:" + this.stateString();
    }

    private String stateString() {
        switch (this.state) {
            case -1: {
                return RUN_STRING;
            }
            case 0: {
                return NO_ERROR_STRING;
            }
            case 1: {
                return FAILED_STRING;
            }
            case 2: {
                return CANCEL_STRING;
            }
            case 3: {
                return PARENT_END_STRING;
            }
            case 20: {
                return HEARTBEAT_STRING;
            }
            case 21: {
                return RESUME_STRING;
            }
            case 22: {
                return SUSPEND_STRING;
            }
        }
        return INVALID_STRING;
    }
}

